#  File: actions.py
# 
#  Copyright (C) 2010 Christopher R. Gabriel <cgabriel@truelite.it> 
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
# 
import os, os.path
import shutil
from gettext import gettext as _
import crypt
    
class Action(object):
  description = ''
  files = []
  priority = 99
  
  def __init__(self, conf):
    self.conf = conf

  def get_description(self):
    return self.description
  
  def recover_file(self, file):
    try:
      shutil.copyfile(file+".orig", file)
    except:
      pass

  def backup_file(self, file):
    shutil.copyfile(file, file+".orig")

  def backup_files(self):
    for file in self.files:
      self.backup_file(file)
      
  def recover_files(self):
    for file in self.files:
      self.recover_file(file)

  def do(self):
    self.backup_files()
    self.real_do()
    
  def undo(self):
    self.recover_files()
    self.real_undo()
    
  def real_do(self):
    pass

  def real_undo(self):
    pass


class MiscDesktopSetup(Action):
  description = _("Misc Desktop Setup")
  files = ['/etc/firefox/syspref.js', '/etc/lightdm/lightdm.conf']
  def real_do(self):
    server = self.conf.get("server", None)
    # sabine added configs, to be tested
    f = open("/etc/firefox/syspref.js", "w")
    f.write("""
// This file can be used to configure global preferences for Firefox
// Example: Homepage
//pref("browser.startup.homepage", "http://www.weebls-stuff.com/wab/");

pref("browser.bookmarks.restore_default_bookmarks", false);
pref("browser.cache.disk.enable", false);
pref("browser.download.manager.closeWhenDone", true);
pref("browser.download.useDownloadDir", false);
pref("browser.migration.version", 6);
pref("browser.places.smartBookmarksVersion", 3);
pref("browser.preferences.advanced.selectedTabIndex", 1);
pref("browser.rights.3.shown", true);
pref("distribution.canonical.bookmarksProcessed", true);
pref("extensions.blocklist.pingCountVersion", 0);
pref("extensions.bootstrappedAddons", "{}");
pref("extensions.databaseSchema", 12);
pref("extensions.enabledAddons", "globalmenu@ubuntu.com:3.2.3,langpack-de@firefox.mozilla.org:13.0.1,langpack-en-GB@firefox.mozilla.org:13.0.1,langpack-en-ZA@firefox.mozilla.org:13.0.1,langpack-fr@firefox.mozilla.org:13.0.1,langpack-it@firefox.mozilla.org:13.0.1,ubufox@ubuntu.com:2.0.3,{972ce4c6-7e08-4474-a285-3208198ce6fd}:13.0.1");
pref("extensions.installCache", "[{\"name\":\"app-system-share\",\"addons\":{\"ubufox@ubuntu.com\":{\"descriptor\":\"/usr/share/mozilla/extensions/{ec8030f7-c20a-464f-9b0e-13a3a9e97384}/ubufox@ubuntu.com\",\"mtime\":1342971231000}}},{\"name\":\"app-global\",\"addons\":{\"globalmenu@ubuntu.com\":{\"descriptor\":\"/usr/lib/firefox/extensions/globalmenu@ubuntu.com\",\"mtime\":1343059585000},\"langpack-de@firefox.mozilla.org\":{\"descriptor\":\"/usr/lib/firefox/extensions/langpack-de@firefox.mozilla.org.xpi\",\"mtime\":1339750388000},\"langpack-en-GB@firefox.mozilla.org\":{\"descriptor\":\"/usr/lib/firefox/extensions/langpack-en-GB@firefox.mozilla.org.xpi\",\"mtime\":1339750388000},\"langpack-en-ZA@firefox.mozilla.org\":{\"descriptor\":\"/usr/lib/firefox/extensions/langpack-en-ZA@firefox.mozilla.org.xpi\",\"mtime\":1339750388000},\"langpack-fr@firefox.mozilla.org\":{\"descriptor\":\"/usr/lib/firefox/extensions/langpack-fr@firefox.mozilla.org.xpi\",\"mtime\":1339750390000},\"{972ce4c6-7e08-4474-a285-3208198ce6fd}\":{\"descriptor\":\"/usr/lib/firefox/extensions/{972ce4c6-7e08-4474-a285-3208198ce6fd}\",\"mtime\":1343059584000},\"langpack-it@firefox.mozilla.org\":{\"descriptor\":\"/usr/lib/firefox/extensions/langpack-it@firefox.mozilla.org.xpi\",\"mtime\":1339750391000}}}]");
pref("intl.charsetmenu.browser.cache", "UTF-8");
pref("network.cookie.prefsMigrated", true);
pref("network.proxy.backup.ftp", "");
pref("network.proxy.backup.ftp_port", 0);
pref("network.proxy.backup.socks", "");
pref("network.proxy.backup.socks_port", 0);
pref("network.proxy.backup.ssl", "");
pref("network.proxy.backup.ssl_port", 0);
pref("network.proxy.ftp", "proxy");
pref("network.proxy.ftp_port", 8080);
pref("network.proxy.http", "proxy");
pref("network.proxy.http_port", 8080);
pref("network.proxy.share_proxy_settings", true);
pref("network.proxy.socks", "proxy");
pref("network.proxy.socks_port", 8080);
pref("network.proxy.ssl", "proxy");
pref("network.proxy.ssl_port", 8080);
pref("network.proxy.type", 1);
pref("places.history.expiration.transient_current_max_pages", 52091);
pref("pref.browser.homepage.disable_button.current_page", false);
pref("privacy.sanitize.migrateFx3Prefs", true);
pref("services.sync.clients.lastSync", "0");
pref("services.sync.clients.lastSyncLocal", "0");
pref("services.sync.globalScore", 0);
pref("services.sync.migrated", true);
pref("services.sync.nextSync", 0);
pref("services.sync.tabs.lastSync", "0");
pref("services.sync.tabs.lastSyncLocal", "0");
pref("xpinstall.whitelist.add", "");
pref("xpinstall.whitelist.add.36", "");
      """)
    f.close()


