#!/bin/sh
#
# testconf.sh: script di controllo che la configurazione sia corretta
#
# Copyright (C) 2003-2005 Truelite s.r.l
# by Simone Piccardi
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program or from the site that you downloaded it
# from; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA  02111-1307   USA
#

# find default gateway interface 
if [ -x /sbin/ip ]; then
    IFACE=`/sbin/ip route | grep default | head -n1 | cut -d" " -f 5`
elif [ -x /sbin/route ]; then
    IFACE=`/sbin/route | grep default | head -n1 | tr -s " " | cut -d" " -f 8`
else 
    echo "Cannot find gateway interface"
fi

if [ -x /sbin/ip ]; then
    GATEWAY=`/sbin/ip route | grep default | head -n1 | cut -d" " -f 3`
elif [ -x /sbin/route ]; then
    GATEWAY=`/sbin/route -n | grep -e "^0\.0\.0\.0"| head -n1 | tr -s " " | cut -d" " -f 2`
else 
    echo "Cannot gateway IP address"
fi

# find local IP
if [ -x /sbin/ip ]; then
    LOCALIP=`/sbin/ip route|grep src|grep $IFACE|tr -s " "|cut -d" " -f 9`
elif [ -x /sbin/ifconfig ]; then 
    LOCALIP=`/sbin/ifconfig | sed -n -r -e '/Link encap:Ether/,+1 p' | grep inet | cut -d: -f2| cut -d" " -f1`
else 
    echo "Cannot find local IP value"
fi
# find local net
if [ -x /sbin/ip ]; then
    LOCALNET=`/sbin/ip route | grep $LOCALIP | cut -d" " -f 1`
else 
    echo "Cannot find local net value"
fi


##
## Questa sezione fa un check ridotto. 
##
if [ "$1" == "short" ];  then
    echo "Hostname: $(hostname), IP: $LOCALIP"
    if ping $GATEWAY -c 3 > /tmp/testconf.log 2>&1; then 
	echo -n 'OK - '
    else
	echo 'KO'
	exit 1
    fi
    if ldapsearch -x >> /tmp/testconf.log 2>&1; then 
	echo -n 'OK - '
    else
	echo 'KO'
	exit 1
    fi
    if getent passwd | grep Administrator >> /tmp/testconf.log 2>&1; then 
	echo -n 'OK - '
    else
	echo 'KO'
	exit 1
    fi
    if smbclient -L //$GATEWAY/ -N  >> /tmp/testconf.log 2>&1 
	then 
	echo -n 'OK - '
    else
	echo 'KO'
	exit 1
    fi
    if mount | grep /home | grep nfs >> /tmp/testconf.log 2>&1 
	then 
	echo -n 'OK - '
    else
	echo 'KO'
	exit 1
    fi
    if ls -d /home/* >> /tmp/testconf.log 2>&1 
	then 
	echo -n 'OK - '
    else
	echo 'KO'
	exit 1
    fi
    if grep timeout /boot/grub/menu.lst >> /tmp/testconf.log 2>&1 
	then
	echo -n 'OK -'
    else
	exit 1
    fi
    RESOLVEDIP=$(host `hostname` | cut -d" " -f 4)
    if [ "$RESOLVEDIP" == "$LOCALIP" ]
	then
	echo -n 'OK -'
    else
	exit 1
    fi
    if ping www.google.com -c 3 >> /tmp/testconf.log 2>&1; then 
	echo -n 'OK - '
    else
	echo 'KO'
	exit 1
    fi
    if wget http://www.google.com  >> /tmp/testconf.log 2>&1 
	then 
	echo -n 'OK - '
    else
	echo 'KO'
	exit 1
    fi
    echo "> All OK"
    exit 0
fi

##
## Caso normale, piu` dettagli
##

echo "############################################################"
echo "     testconf.sh controlla la configurazione del client"
echo "     un log coi risultati  in /tmp/testconf.log"
echo "     Hostname: $(hostname), IP: $LOCALIP"
echo "############################################################"

if ping $GATEWAY -c 3 > /tmp/testconf.log 2>&1; then 
    echo 'OK - Gateway raggiungibile correttamente'
else
    echo "ERRORE:"
    echo "Gateway irraggiungibile, controllare: "
    echo "  - se  configurata la rete"
    echo "  - se dhcpd  attivo sul server"
    exit 1
fi

if ldapsearch -x >> /tmp/testconf.log 2>&1; then 
    echo 'OK - LDAP server raggiungibile correttamente'
else
    echo "ERRORE:"
    echo "LDAP server irraggiungibile, controllare: "
    echo "  - se slapd  attivo sul server"
    echo "  - se /etc/ldap/ldap.conf  corretto"
    exit 1
fi

if getent passwd | grep Administrator >> /tmp/testconf.log 2>&1; then 
    echo 'OK - Il name service switch funziona correttamente'
else
    echo "ERRORE:"
    echo "Il name service switch non funziona correttamente, controllare:"
    echo "  - se nsswitch.conf  corretto"
    echo "  - se libnss-ldap.conf  corretto"
    exit 1
fi

if smbclient -L //$GATEWAY/ -N  >> /tmp/testconf.log 2>&1 
then 
    echo "OK - Samba risponde a smbclient -L" 
else
    echo "ERRORE:"
    echo "Samba non risponde, controllare sul server:"
    echo "  - se smbd  attivo"
    echo "  - se smb.conf  corretto"
    exit 1
fi

if mount | grep /home | grep nfs >> /tmp/testconf.log 2>&1 
then 
    echo "OK - Home su NFS montata" 
else
    echo "ERRORE:"
    echo "Home non montata su NFS, controllare:"
    echo "  - se i demoni stanno girando (client e server)"
    echo "  - se fstab  corretto"
    echo "  - se l'indirizzo del server  corretto"
    exit 1
fi


if ls -d /home/* >> /tmp/testconf.log 2>&1 
then 
    echo "OK - Dati presenti sulle home" 
else
    echo "ERRORE:"
    echo "Home montata su NFS non presenta dati, controllare:"
    echo "  - se i demoni stanno girando (client e server)"
    echo "  - se il server  stato riavviato"
    exit 1
fi

if grep timeout /boot/grub/menu.lst >> /tmp/testconf.log 2>&1 
then
    echo "OK - Timeout per GRUB configurato"
else
    echo "ERRORE:"
    echo "La configurazione di GRUB non contiene timeout"
    echo "al riavvio la macchina non partir automaticamente"
    echo "qualcosa  andato storto nell'installazione, controllare:"
    echo "  - i vari /boot/grub/menu.lst.* "
    echo "  - che l'attuale /boot/grub/menu.lst sia corretto"
    exit 1
fi


RESOLVEDIP=$(host `hostname` | cut -d" " -f 4)
if [ "$RESOLVEDIP" == "$LOCALIP" ]
then
    echo "OK - risolvo l'hostname sulla zona locale"
else
    echo "ERRORE:"
    echo "La configurazione del DNS e del DHCP hanno problemi"
    echo "non riesco a risolvere l'hostname della macchina sul server"
    echo "qualcosa non va nell'interazione DNS-DHCP, controllare:"
    echo "  - che /etc/bind/rndc.key contenga la chiave corretta"
    echo "  - che /etc/dhcp3/dhcpd.conf usi la precedente chiave"
    echo "  - i messaggi dei suddetti demin in /var/log/syslog"
    exit 1
fi

if ping www.google.com -c 3 >> /tmp/testconf.log 2>&1; then 
    echo 'OK - Google raggiungibile correttamente'
else
    echo "ERRORE:"
    echo "Google irraggiungibile, controllare: "
    echo "  - se resolv.conf  a posto"
    echo "  - se bind  attivo sul server"
    echo "  - se le zone sono state caricate correttamente"
    exit 1
fi

if wget http://www.google.com  >> /tmp/testconf.log 2>&1 
then 
    echo "OK - Web proxy funzionante, scaricata homepage di google" 
else
    echo "ERRORE:"
    echo "Web non raggiungibile, controllare:"
    echo "  - se il default gatweay  impostato correttamente"
    echo "  - se sul server squid e dansguardian sono attivi"
    exit 1
fi



echo 
echo "-------    I test si sono conclusi con successo !    -------"
