#!/bin/sh

touch /root/homes_should_we_delete_them

# Maybe here we could check for an nfs mount
if $(mount | grep home)
then
    echo "Home directory is mounted from a different partition, bailing out"
    exit 0
fi

if $(grep ':/home' /etc/passwd)
then
    echo "Local users with a home in /home found, baling out"
    exit 0
fi

FUSS_ZONE=$(cat /etc/fuss-client/fuss-zone.yaml)
if [ "$FUSS_ZONE" != 'fuss_zone: "Prov-BZ"' ]
then
    echo "fuss_zone not set to Prov-BZ, bailing out"
    exit 0
fi

touch /root/homes_will_be_deleted

rm -rf /home/*

touch /root/homes_have_been_deleted
