#!/bin/bash

USER=$(loginctl list-sessions --no-legend | awk "{print \$3}" | tail -n1)
[ -z "$USER" ] && exit 0 
EXCLUDED_GROUPS_FILE=/var/lib/fuss-client/veyon-excluded-groups 
if [ -r "$EXCLUDED_GROUPS_FILE" ]; then 
    EXCLUDED_GROUPS="$(xargs < "$EXCLUDED_GROUPS_FILE")" 
else 
    EXCLUDED_GROUPS="root docenti insegnanti veyon-master tecnici" 
fi  

USER_GROUPS=" $(id -nG "$USER") " 
for group in $EXCLUDED_GROUPS; do 
    echo "$USER_GROUPS" | grep -q " $group " && systemctl stop veyon || true
    /usr/bin/python3 /usr/share/fuss-client/roles/veyon/files/veyon-sync-pc-list || true 
    exit 0
done
exit 0

