#
# shell functions used by some step scripts
# you need to source them when needed using
# . $SCRIPTS_DIR/functions.sh
#
# 
# Copyright (C) 2025 FUSS Project <info@fuss.bz.it>
# Authors: Simone Piccardi <piccardi@truelite.it>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program or from the site that you downloaded it
# from; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA  02111-1307   USA
#

# function to execute dpkg --configure -a

function exec_dpkg_configure () {
    echo "# Check for unconfigured packages and retry configuration"
    dpkg --configure -a
    if [ $? != 0 ]; then
	echo "#   Unconfigurables package remains, we must stop"
	echo FAILED > $STEPRES
	exit 1
    fi
}

# function to check if already on debian13

function check_already_debian13 () {
    echo "# Check if re-running after a partial upgrade to Debian 13"
    . /etc/os-release
    if [ $VERSION_ID = 13 ]; then
	echo "#  Already in Debian 13, this step is not needed"
	echo PASSED > $STEPRES
	exit 0
    fi
}
