#!/usr/bin/python3

# Step script for Debian major version upgrade for fuss
#
# Copyright (C) 2025 FUSS Project <info@fuss.bz.it>
# Authors: Elena Grandi <elena@truelite.it>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program or from the site that you downloaded it
# from; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA  02111-1307   USA

# List packages that are not available in the currently configured
# repositories.

import apt


def main():
    # https://apt-team.pages.debian.net/python-apt/library/apt.cache.html#the-cache-class
    cache = apt.Cache()
    for pkg in cache:
        # https://apt-team.pages.debian.net/python-apt/library/apt.package.html
        if not any([v.downloadable for v in pkg.versions]):
            # removing the old kernel after an upgrade, but before a
            # reboot, will fail, so we blacklist it and old kernels will
            # have to be cleaned in a different way.
            if not pkg.name.startswith("linux-image"):
                print(pkg.name)


if __name__ == "__main__":
    main()
