#! /bin/bash

#
# cert-renew.sh, script per rinnovare il certificato del server LDAP
#
# Copyright (C) 2025 FUSS Project <info@fuss.bz.it>
# Authors: Simone Piccardi <piccardi@truelite.it>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program or from the site that you downloaded it
# from; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA  02111-1307   USA
#

# Get easyrsa PKI data DIR
PKI_DIR=$(find /etc/fuss-server/ -name pki)
KEY_FILE=$(grep TLSCertificateKeyFile /etc/ldap/slapd.conf|awk '{print $2}')
CERT_FILE=$(grep TLSCertificateFile /etc/ldap/slapd.conf|awk '{print $2}')
CN=$(openssl x509 -subject -noout -in $CERT_FILE|cut -d= -f3)
CERT_CN=$(echo $CN)

EXPIRE=$(openssl x509 -enddate -noout -in $CERT_FILE|cut -d= -f2|date +%s -f -)
ENDATE=$(openssl x509 -enddate -noout -in $CERT_FILE|cut -d= -f2)
DAYS=$(( 365 * 5 ))

if [ $EXPIRE -lt $(date +%s) ]; then
    echo Certificate expired on $ENDATE, renewing
    # Go un the base directory for issuing command
    cd $PKI_DIR/..
    [ -d oldCERTS ] || mkdir oldCERTS
    mv pki/issued/$CERT_CN.crt oldCERTS
    mv pki/private/$CERT_CN.key oldCERTS
    mv pki/reqs/$CERT_CN.req oldCERTS
    mv $CERT_FILE oldCERTS
    mv $KEY_FILE  oldCERTS
    ./easyrsa --days=$DAYS build-client-full $CERT_CN nopass
    cp -a pki/issued/$CERT_CN.crt $CERT_FILE
    cp -a pki/private/$CERT_CN.key $KEY_FILE
    chmod g+r $KEY_FILE
    chgrp ssl-cert $KEY_FILE
    chmod +r $CERT_FILE
    systemctl restart slapd.service
else
    echo Certificate still valid, expiring $ENDATE
fi

