#! /usr/bin/env python3
#
# Script per il salvataggio dei dati di stampa di CUPS su DB SQLite
#
# Copyright (C) 2025-2026 FUSS Project <info@fuss.bz.it>
# Authors: Claudio Cavalli <ccavalli@fuss.bz.it>
#          Simone Piccardi <piccardi@truelite.it>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

import datetime, sqlite3

# open DB file, and create table if absent
con = sqlite3.connect("/var/lib/log/cupspages.db")
cur = con.cursor()
cur.execute("CREATE TABLE IF NOT EXISTS jobs (user TEXT, pages INTEGER, printer TEXT, file TEXT, time TEXT)")

# read print data
try:
    with open("/var/log/cups/page_log") as f:
        for line in f:
            line = line.strip()
            if line.startswith('"') and line.endswith('"'):
                line = line[1:-1]

            parts = line.split(",")
        
            if len(parts) < 6:
                continue

            printer = parts[0]
            user    = parts[1]
            pages   = parts[5]
            file    = parts[7]
            time    = parts[2][1:-1]
            date    = datetime.datetime.strptime(time, "%d/%b/%Y:%H:%M:%S %z")
            today   = datetime.datetime.now()
            if date.strftime('%Y-%m-%d') != today.strftime('%Y-%m-%d'):
                continue
            
            #print (user, printer, file, pages, date.strftime('%Y-%m-%d'))

            cur.execute("INSERT INTO jobs VALUES (?, ?, ?, ?, ?)",
                       (user, pages, printer, file, date.strftime('%Y-%m-%d')))
        con.commit()
except FileNotFoundError:
    print("The file '/var/log/cups/page_log' was not found.")
    
# closing DB connection
con.close()

