from django.conf.urls import url
from . import views

app_name = "dhcp"
urlpatterns = [
    url(r"^$", views.List.as_view(), name="list"),
    # refs #244
    url(r"^static/list$", views.StaticEntryList.as_view(), name="static_entry_list"),
    url(
        r"^static/create$",
        views.StaticEntryCreate.as_view(),
        name="static_entry_create",
    ),
    # Is this the right regexp for a hostname?
    url(
        r"^static/(?P<hostname>[\w_\-]+)/update$",
        views.StaticEntryUpdate.as_view(),
        name="static_entry_update",
    ),
    # Is this the right regexp for a hostname?
    url(
        r"^static/(?P<hostname>[\w_\-]+)/delete$",
        views.StaticEntryDelete.as_view(),
        name="static_entry_delete",
    ),
]
