# coding: utf-8
from django.conf.urls import url
from django.views.generic.base import RedirectView
from . import views


app_name = "host"
urlpatterns = [
    url(r'^$', RedirectView.as_view(pattern_name='host:list', permanent=True), name='home'),
    url(r"^list/(?P<group>[^/]+)?$", views.List.as_view(), name="list"),
    url(r"^edit/(?P<name>[^/]+)$", views.HostEdit.as_view(), name="host_edit"),
    url(r"^group/detail/(?P<group>[^/]+)$", views.GroupDetail.as_view(), name="group_detail"),
    url(r"^group/empty/(?P<group>[^/]+)", views.EmptyGroup.as_view(), name="group_empty"),
    url(r"^group/create/$", views.GroupCreate.as_view(), name="group_create"),
    # Can name be empty? For example when type == 'all'?
    url(
        r"^actions/(?P<type>(host|group|all|avahihost|avahigroup))/(?P<name>[\w_\-\+\%\.]+)?$",
        views.ActionsAJAX.as_view(),
        name="actions_ajax",
    ),
    # refs #71. Add _type to type kwarg to allow creating a "dummy" url in the template and subsequent
    # fix in actions.js (which has no access to django template language/filters/tags)
    url(
        r"^action/(?P<action>[\w_]+)/(?P<type>(host|group|all|avahihost|avahigroup|_type))/(?P<name>.+)$",
        views.ActionAJAX.as_view(),
        name="action_ajax",
    ),
    url(r"^action/completion/$", views.ActionCompletionAJAX.as_view(), name="action_completion_ajax"),
]
