from django.conf.urls import url, include
from . import views

urlpatterns = [
    url(r"^$", views.Home.as_view(), name="home"),
    url(r"^login/$", views.Login.as_view(), name="login"),
    url(r"^logout/$", views.Logout.as_view(), name="logout"),
    url(r"^newsfeed/$", views.NewsFeed.as_view(), name="newsfeed"),
    url(r"^veyon/client_conf$", views.VeyonClientConfiguration.as_view(), name="veyon-client-conf"),
    url(r"^octofussd-error/$", views.OctofussdError.as_view(), name="octofussd_error"),
    url(r'^i18n/', include('django.conf.urls.i18n')),
    url(r"^hostqueue/", include("hostqueue.urls", namespace="hostqueue")),
    url(r"^dhcp/", include("dhcp.urls", namespace="dhcp")),
    url(r"^polygen/", include("polygen.urls", namespace="polygen")),
    url(r"^firewall/", include("firewall.urls", namespace="firewall")),
    url(r"^dansguardian/", include("dansguardian.urls", namespace="dansguardian")),
    url(r"^host/", include("host.urls", namespace="host")),
    url(r"^upgrade/", include("upgrade.urls", namespace="upgrade")),
    url(r"^asterisk/", include("asterisk.urls", namespace="asterisk")),
    url(r"^samba/", include("samba.urls", namespace="samba")),
    url(r"^users/", include("users.urls", namespace="users")),
    url(r"^script/", include("script.urls", namespace="script")),
    url(r"^quota/", include("quota.urls", namespace="quota")),
    url(r"^printers/", include("printers.urls", namespace="printers")),
    url(r"^services/", include("services.urls", namespace="services")),
    url(r"^auth/", include("auth.urls", namespace="auth")),
    url(r"^fussmanager/", include("fussmanager.urls", namespace="fussmanager")),
]
