from django.conf.urls import url
from . import views


app_name = "printers"
urlpatterns = [
    url(r"^$", views.List.as_view(), name="list"),
    url(r"^edit/(?P<queue>[^/]+)$", views.Edit.as_view(), name="edit"),
    url(r"^remove_all/(?P<queue>[^/]+)/$", views.RemoveAllFromQueue.as_view(), name="remove-all"),
    url(r"^remove/(?P<queue>[^/]+)/(?P<host>[^/]+)$", views.Remove.as_view(), name="remove"),
    url(r"^add/(?P<queue>[^/]+)$", views.Add.as_view(), name="add"),
    url(r"^add_cluster/(?P<queue>[^/]+)$", views.AddCluster.as_view(), name="add_cluster"),
    # refs #12376 #566
    url(r"^cleanup/$", views.Cleanup.as_view(), name="cleanup"),
]
