from django.conf.urls import url
from . import views


app_name = "script"
urlpatterns = [
    url(r"^$", views.List.as_view(), name="list"),
    url(r"^create$", views.Create.as_view(), name="create"),
    url(r"^edit/(?P<name>[^/]+)$", views.Edit.as_view(), name="edit"),
    url(r"^runs/(?P<name>[^/]+)$", views.ListRuns.as_view(), name="list_runs"),
    url(r"^runs/(?P<name>[^/]+)/edit/(?P<run>[^/]+)$", views.EditRun.as_view(), name="edit_run"),
    url(r"^runs/(?P<name>[^/]+)/edit/(?P<run>[^/]+)/delete$", views.DeleteRun.as_view(), name="delete_run"),
    url(r"^runs/(?P<name>[^/]+)/edit/(?P<run>[^/]+)/schedule$", views.Schedule.as_view(), name="schedule_run"),
    url(r"^runs/(?P<name>[^/]+)/edit/(?P<run>[^/]+)/remove-host$", views.RemoveHost.as_view(), name="edit_run_remove_host"),
]
