from django.conf.urls import url
from . import views

app_name = "upgrade"
urlpatterns = [
    url(r"^$", views.List.as_view(), name="list"),
    url(r"^edit/(?P<name>[^/]+)$", views.Edit.as_view(), name="edit"),
    url(r"^schedule/(?P<name>[^/]+)$", views.Schedule.as_view(), name="schedule"),
    url(r"^delete/(?P<name>[^/]+)$", views.Delete.as_view(), name="delete"),
    url(r"^update/(?P<name>[^/]+)$", views.Update.as_view(), name="update"),
    url(r"^complete/(?P<domain>[^/]+)$", views.Complete.as_view(), name="complete"),
    url(r"^hosts/add/(?P<name>[^/]+)$", views.AddHost.as_view(), name="add_host"),
    url(r"^hosts/remove/(?P<name>[^/]+)$", views.RemoveHost.as_view(), name="remove_host"),
    url(r"^hosts/addgroup/(?P<name>[^/]+)$", views.AddGroup.as_view(), name="add_group"),
    url(r"^hosts/removegroup/(?P<name>[^/]+)$", views.RemoveGroup.as_view(), name="remove_group"),
]
