from django.conf.urls import url
from . import views


app_name="users"
urlpatterns = [
    url(r"^user/list$", views.UserList.as_view(), name="list"),
    url(r"^user/list_json", views.UserListJSON.as_view(), name="list_json"),
    url(r"^user/create", views.UserCreate.as_view(), name="user_create"),
    url(r"^user/(?P<uid>[^/]+)/detail$", views.UserDetail.as_view(), name="detail"),
    url(r"^user/(?P<uid>[^/]+)/edit$", views.UserEdit.as_view(), name="user_edit"),
    url(r"^user/(?P<uid>[^/]+)/set-enabled$", views.UserSetEnabled.as_view(), name="user_set_enabled"),
    # refs #12559
    # refs #14151: Hide the button that made POST to this view
    # url(r"^user/(?P<uid>[^/]+)/force-password-change$", views.UserForcePasswordChange.as_view(), name="user_force_password_change"),
    url(r"^user/(?P<uid>[^/]+)/add-group$", views.UserAddGroup.as_view(), name="user_add_group"),
    # refs #213
    url(r"^user/(?P<uid>[^/]+)/delete$", views.UserDelete.as_view(), name="user_delete"),
    url(r"^groups/list$", views.GroupList.as_view(), name="group_list"),
    # refs #212
    url(r"^group/create$", views.GroupCreate.as_view(), name="group_create"),
    url(r"^group/(?P<name>[^/]+)/detail$", views.GroupDetail.as_view(), name="group_detail"),
    url(r"^group/(?P<name>[^/]+)/edit$", views.GroupEdit.as_view(), name="group_edit"),
    url(r"^group/(?P<name>[^/]+)/add-group$", views.GroupAddGroup.as_view(), name="group_add_group"),
    url(r"^group/(?P<name>[^/]+)/remove-group$", views.GroupRemoveGroup.as_view(), name="group_remove_group"),
    url(r"^group/(?P<name>[^/]+)/drop-all-users$", views.GroupDropAllUsers.as_view(), name="group_drop_all_users"),
    url(r"^group/(?P<name>[^/]+)/add-permission$", views.GroupAddPermission.as_view(), name="group_add_perm"),
    url(r"^group/(?P<name>[^/]+)/remove-permission$", views.GroupRemovePermission.as_view(), name="group_remove_perm"),
    url(r"^group/(?P<name>[^/]+)/delete$", views.GroupDelete.as_view(), name="group_delete"),
    url(r"^csvimport$", views.CSVImport.as_view(), name="csvimport"),
    url(r"^csvimport_ajax$", views.CSVImportAJAX.as_view(), name="csvimport_ajax"),
    # refs #353
    url(r"^csvimport/check$", views.CSVImportCheck.as_view(), name="csvimport_check"),
    url(r"^masscreate$", views.MassCreate.as_view(), name="masscreate"),
    # refs #108
    url(r"^massedit$", views.MassEdit.as_view(), name="massedit"),
    url(r"^processldif", views.ProcessLDIF.as_view(), name="processldif"),
]
