"""
Django settings for octonet project.

Generated by 'django-admin startproject' using Django 1.10.3.

For more information on this file, see
https://docs.djangoproject.com/en/1.8/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.8/ref/settings/
"""

import os
import pwd

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# OCTONET SPECIFIC SETTINGS
OCTONET_MANAGED_SERVERS = [
    ("http://localhost:13400/conf/", "localhost"),
]

NEWS_FEED_URL = "https://work.fuss.bz.it/news.atom"

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.8/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '#94nh)d^tyv489f=#5co@xyg%gadl$n757@ev6uwb9wao@^jr9'
# refs #915
# openssl rand -base64 32
FUSS_MANAGER_AUTH_FORWARD_KEY = 'mock-auth-forward-secret'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = [
    'django.contrib.sessions',
    'django.contrib.messages',
    'whitenoise.runserver_nostatic',
    'django.contrib.staticfiles',
    'octonet',
    'hostqueue.apps.HostQueue',
    'firewall.apps.Firewall',
    'dhcp.apps.Dhcp',
    'dansguardian.apps.DansGuardian',
    'host.apps.Host',
    'polygen.apps.Polygen',
    'upgrade.apps.Upgrade',
    'asterisk.apps.Asterisk',
    'samba.apps.Samba',
    'users.apps.Users',
    'script.apps.Script',
    'quota.apps.Quota',
    'printers.apps.Printers',
    'services.apps.Services',
    'auth.apps.Auth',
    'fussmanager.apps.FussManager',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'whitenoise.middleware.WhiteNoiseMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.middleware.locale.LocaleMiddleware',
    'octonet.middleware.AuthenticationMiddleware',
    # 'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'octonet.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                "django.template.context_processors.i18n",
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'octonet.wsgi.application'

SESSION_ENGINE = "django.contrib.sessions.backends.cache"

# CACHES = {
#     'default': {
#         'BACKEND': 'django.core.cache.backends.locmem.LocMemCache',
#         'LOCATION': 'unique-snowflake',
#     }
# }

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.filebased.FileBasedCache',
        'LOCATION': "/var/cache/octonet/",
    }
}

# Internationalization
# https://docs.djangoproject.com/en/1.8/topics/i18n/


LANGUAGE_CODE = 'en'

# languages we're going to use
LANGUAGES = (
        ("en", "English"),
        ("it", "Italiano"),
        ("de", "Deutsch"),
        )

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True

LOCALE_PATHS = [os.path.join(BASE_DIR, "locale")]

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.8/howto/static-files/

STATIC_URL = '/static/'

STATIC_ROOT = "/var/cache/octonet/static"

LOGGING = {
    'version': 1,
    # 'disable_existing_loggers': False,
    'filters': {
        'require_debug_false': {
            '()': 'django.utils.log.RequireDebugFalse',
        },
        'require_debug_true': {
            '()': 'django.utils.log.RequireDebugTrue',
        },
    },
    'formatters': {
        'logfile': {
            'format': '[%(asctime)s %(module)s] %(levelname)s: %(message)s',
        },
    },
    'handlers': {
        'console': {
            'level': 'INFO',
            'class': 'logging.StreamHandler',
        },
        'null': {
            'class': 'logging.NullHandler',
        },
        'mail_admins': {
            'level': 'ERROR',
            'filters': ['require_debug_false'],
            'class': 'django.utils.log.AdminEmailHandler'
        },
        'file': {
            'level': 'DEBUG',
            'class': 'logging.handlers.TimedRotatingFileHandler',
            'filename': '/var/log/octonet/octonet.log' if os.path.isdir('/var/log/octonet') else 'octonet.log',
            'when': 'midnight',
            'backupCount': 365,
            'filters': ['require_debug_false'],
            'formatter': 'logfile',
        },
    },
    'loggers': {
        'django': {
            'handlers': ['console'],
        },
        'django.request': {
            'handlers': ['file'],
            'level': 'INFO',
            'propagate': True,
        },
        'django.security': {
            'handlers': ['mail_admins', 'file'],
            'level': 'ERROR',
            'propagate': False,
        },
        'django.db.backends': {
            'level': 'INFO',
            'handlers': ['file'],
            'propagate': True,
        },
        'py.warnings': {
            'handlers': ['console'],
        },
    },
    'root': {
        'level': 'INFO',
        'handlers': ['file', 'console'],
    },
}


try:
    from .local_settings import *
except ImportError:
    pass

# If running as octonet, source /etc/octonet.conf at this point
if pwd.getpwuid(os.getuid())[0] == "octonet" and os.path.exists("/etc/octonet.conf"):
    with open("/etc/octonet.conf", "rt") as fd:
        exec(fd.read())
